

<?php $__env->startSection('title', 'Login'); ?>

<?php $__env->startSection('content'); ?>
<div class="card card-bordered">
    <div class="card-inner card-inner-lg">
        <div class="nk-block-head">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title"><?php echo e(__('Login into Account')); ?></h4>
                <div class="nk-block-des mt-2">
                    <p><?php echo e(__('Sign in into your account using your email and passcode.')); ?></p>
                </div>
            </div>
        </div>
        <?php echo $__env->make('auth.partials.error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if(session()->has('mail_sent_success')): ?>
        <div class="alert alert-primary">
            <ul>
                <li class="alert-icon centered"><em class="icon ni ni-mail-fill"></em><?php echo e(session()->get('mail_sent_success')); ?></li>
            </ul>
        </div>
        <?php endif; ?>
        <form action="<?php echo e(route('auth.login')); ?>" autocomplete="off" method="POST" id="loginForm" class="form-validate is-alter">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <div class="form-label-group">
                    <label class="form-label" for="username"><?php echo e(__('Email Address')); ?> <span class="text-danger">*</span></label>
                </div>
                <div class="form-control-wrap">
                    <input name="email" type="email" autocomplete="new-email" class="form-control form-control-lg" id="username" placeholder="<?php echo e(__('Enter your email address')); ?>" autocomplete="off" data-msg-email="<?php echo e(__('Enter a valid email.')); ?>" data-msg-required="<?php echo e(__('Required.')); ?>" required>
                </div>
            </div>
            <div class="form-group">
                <div class="form-label-group">
                    <label class="form-label" for="passcode"><?php echo e(__('Password')); ?> <span class="text-danger">*</span></label>
                </div>
                <div class="form-control-wrap">
                    <a tabindex="-1" href="#" class="form-icon form-icon-right passcode-switch" data-target="passcode">
                        <em class="passcode-icon icon-show icon ni ni-eye-off"></em>
                        <em class="passcode-icon icon-hide icon ni ni-eye"></em>
                    </a>
                    <input name="password" autocomplete="new-password" type="password" class="form-control form-control-lg" id="passcode" placeholder="<?php echo e(__('Enter your passcode')); ?>" minlength="6" data-msg-required="<?php echo e(__('Required.')); ?>" data-msg-minlength="<?php echo e(__('At least :num chars.', ['num' => 6])); ?>" required>
                </div>
                <div class="form-control-group d-flex justify-between mt-2 mb-gs">
                    <div class="form-control-wrap">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="remember" id="remember-me">
                            <label class="custom-control-label text-soft" for="remember-me"><?php echo e(__('Remember Me')); ?></label>
                        </div>
                    </div>
                    <div class="form-control-link">
                        <a tabindex="5" class="link link-primary" href="<?php echo e(route('auth.forget.form')); ?>"><?php echo e(__('Forgot Code?')); ?></a>
                    </div>
                </div>
            </div>
            <?php if(has_restriction()): ?>
            <div class="text-danger text-center font-italic small mb-1">
                <?php echo 'You are about to login into demo application to see the platform.'; ?>

            </div>
            <?php endif; ?>
            <div class="form-group">
                <?php if(has_recaptcha()): ?>
                    <input type="hidden" id="recaptcha" value="" name="recaptcha">
                <?php endif; ?>
                <button class="btn btn-lg btn-primary btn-block"><?php echo e(__('Login')); ?></button>
            </div>
        </form>
        <?php if(allowed_signup()): ?>
            <div class="form-note-s2 text-center pt-4"> <?php echo e(__('New on our platform?')); ?> <a href="<?php echo e(route('auth.register')); ?>"><strong><?php echo e(__('Create an account')); ?></strong></a>
            </div>
        <?php endif; ?>
        <?php echo $__env->make('auth.partials.socials', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php if(has_recaptcha()): ?>
<?php $__env->startPush('scripts'); ?>
<script>
    grecaptcha.ready(function() {
        grecaptcha.execute('<?php echo e(recaptcha_key("site")); ?>', {action: 'login'}).then(function(token) {
            document.getElementById('recaptcha').value=token;
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make('auth.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/auth/login.blade.php ENDPATH**/ ?>