
<?php $__env->startSection('title', __('Withdraw Method')); ?>

<?php $__env->startSection('has-content-sidebar', 'has-content-sidebar'); ?>

<?php $__env->startSection('content-sidebar'); ?>
    <?php echo $__env->make('admin.settings.content-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"><?php echo e(__('Withdraw Methods')); ?></h3>
                    <p><?php echo e(__('Manage user withdraw method to withdraw their money.')); ?></p>
                </div>
                <div class="nk-block-head-content">
                    <ul class="nk-block-tools gx-1">
                        <li class="d-lg-none">
                            <a href="javascript:void(0)" class="btn btn-icon btn-trigger toggle" data-target="pageSidebar"><em class="icon ni ni-menu-right"></em></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="nk-block card card-bordered nk-block-mh">
            <div class="card-inner">
                <?php if(is_demo()): ?>
                    <div class="alert alert-danger alert-dim mb-4">
                        <?php echo 'All the <span class="badge badge-pill badge-danger">Add-ons</span> OR <span class="badge badge-pill badge-dark">Extra</span> modules is NOT part of main product. You have to purchase separately to get those. You may <strong><a class="alert-link" href="'. the_link('softn' . 'io' .'.com' .'/'. 'contact'). '" target="_blank">contact us</a></strong> for more info.'; ?>

                    </div>
                <?php endif; ?>
                <?php if(!blank($withdrawMethods)): ?>
                <ul class="cl-pm-list">
                    <?php $__currentLoopData = $withdrawMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="cl-pm-item">
                        <div class="cl-pm-desc">
                            <div class="cl-pm-icon"><em class="icon ni <?php echo e(data_get($method, 'full_icon')); ?>"></em></div>
                            <div class="cl-pm-info">
                                <h6 class="cl-pm-title">
                                    <a href="<?php echo e(has_route('admin.settings.gateway.withdraw.'.data_get($method, 'slug')) ? route('admin.settings.gateway.withdraw.'.data_get($method, 'slug')) : 'javascript:void(0)'); ?>">
                                        <span class="cl-pm-name"><?php echo e(data_get($method, 'name')); ?> <?php if(data_get($method, 'is_addon', false)): ?> <span class="badge badge-pill badge-danger"><?php echo e(__('Add-ons')); ?></span></span> <?php elseif(data_get($method, 'system.addons', false)): ?> <span class="badge badge-pill badge-dark"><?php echo e(__('Extra')); ?></span> <?php endif; ?>
                                    </a>
                                </h6>
                                <div class="cl-pm-meta">
                                    <span class="meta-opt">
                                        <span class="text-soft"><?php echo e(__('Minimum Withdraw:')); ?></span> <span><?php echo e(money(data_get($methodDetail, data_get($method, 'slug').'.min_amount'), base_currency())); ?></span>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="cl-pm-btn">
                            <?php if(has_route('admin.settings.gateway.withdraw.'.data_get($method, 'slug'))): ?>
                                <ul class="btn-group gx-4">
                                    <li class="align-center ml-2">
                                        <?php if(data_get($methodDetail, data_get($method, 'slug').'.has_config')): ?>
                                            <div class="custom-control custom-control-sm custom-switch">
                                                <input type="checkbox" class="custom-control-input dwm-quick-action" data-slug="<?php echo e(data_get($method, 'slug')); ?>" data-action="withdraw" id="wm-<?php echo e(Str::slug(data_get($method, 'name'))); ?>"<?php echo e((data_get($methodDetail, data_get($method, 'slug').'.status') == 'active') ? ' checked': ''); ?>>
                                                <label class="custom-control-label text-soft" for="wm-<?php echo e(Str::slug(data_get($method, 'name'))); ?>"><?php echo e(__('Enable')); ?></label>
                                            </div>
                                        <?php endif; ?>
                                    </li>

                                    <li>
                                        <a href="<?php echo e(route('admin.settings.gateway.withdraw.'.data_get($method, 'slug'))); ?>" class="btn btn-icon btn-trigger">
                                            <em class="icon ni ni-setting"></em>
                                        </a>
                                    </li>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <?php endif; ?>
                <div class="notes mt-4">
                    <ul>
                        <li class="alert-note is-plain text-danger">
                            <em class="icon ni ni-alert"></em>
                            <p><?php echo e(__("Caution: If you disable any withdraw method then users unable to add new account using that method.")); ?></p>
                        </li>
                        <li class="alert-note is-plain">
                            <em class="icon ni ni-info"></em>
                            <p><?php echo e(__("Users can still access and update their existing account if any withdraw method is not enabled.")); ?></p>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
    const routes = { withdraw: "<?php echo e(route('admin.settings.gateway.quick')); ?>" }, msgs = { withdraw: { title: "<?php echo e(__('Are you sure?')); ?>", btn: {cancel: "<?php echo e(__('Cancel')); ?>", confirm: "<?php echo e(__('Yes')); ?>"}, context: "<?php echo __("Do you want to perform this action?"); ?>", custom: "", type: "info" } };
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/settings/gateway-withdraw.blade.php ENDPATH**/ ?>