
<?php $__env->startSection('title', __('Crypto Wallet - Payment Method')); ?>

<?php $__env->startSection('content'); ?>
    <div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"><?php echo e(__('Payment Methods')); ?></h3>
                    <p><?php echo e(__('Manage payment methods to receive payment from user.')); ?></p>
                </div>
                <div class="nk-block-head-content">
                    <ul class="nk-block-tools gx-1">
                        <li class="d-lg-none">
                            <a href="javascript:void(0)" class="btn btn-icon btn-trigger toggle" data-target="pageSidebar"><em class="icon ni ni-menu-right"></em></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="nk-block card card-bordered nk-block-mh">
            <div class="card-inner">
                <div class="justify-between">
                    <h5 class="title"><?php echo e(__('Crypto Wallets')); ?> <span class="meta ml-1"><span class="badge badge-pill badge-xs badge-light"><?php echo e(__('Core')); ?></span></span></h5>
                    <div class="go-back"><a class="back-to" href="<?php echo e(route('admin.settings.gateway.payment.list')); ?>"><em class="icon ni ni-arrow-left"> </em> <?php echo e(__('Back')); ?></a></div>
                </div>
                <p><?php echo e(__('Receive crypto (ETH, BTC, LTC, etc) payment manually on the platform.')); ?></p>
                <div class="divider"></div>
                <div class="row">
                    <div class="col-12">
                        <form action="<?php echo e(route('admin.settings.gateway.payment.crypto-wallet.save')); ?>" class="form-settings" method="POST">
                            <div class="form-set wide-md">
                                <h6 class="title mb-3"><?php echo e(__('Method Setting')); ?></h6>
                                <div class="row gy-3">
                                    <div class="col-12 col-xxl-6">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Method Title')); ?> <span class="text-danger">*</span></label>
                                            <div class="form-control-wrap">
                                                <input type="text" name="name" class="form-control" value="<?php echo e(data_get($settings, 'name', __('Pay with Crypto'))); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-xxl-6">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Description')); ?> <span class="text-danger">*</span></label>
                                            <div class="form-control-wrap">
                                                <input type="text" name="desc" value="<?php echo e(data_get($settings, 'desc', __('Send your payment direct to our wallet.'))); ?>" class="form-control">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-sm-6 col-md-4 col-xl-6 col-xxl-3">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Minimum Deposit')); ?> <small><sup>1</sup></small></label>
                                            <div class="form-control-wrap">
                                                <div class="form-text-hint"><span><?php echo e(base_currency()); ?></span></div>
                                                <input type="number" class="form-control" name="min_amount" value="<?php echo e(data_get($settings, 'min_amount', '1')); ?>" min="0">
                                            </div>
                                            <div class="form-note"><?php echo e(__('Amount will be convert')); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-4 col-xl-6 col-xxl-3">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Secondary Currency')); ?></label>
                                            <div class="form-control-wrap">
                                                <select name="config[meta][fiat]" class="form-select">
                                                    <option<?php echo e((data_get($settings, 'config.meta.fiat')=='alter') ? ' selected ' : ''); ?> value="alter"><?php echo e(__('Secondary Currency')); ?></option>
                                                    <?php $__currentLoopData = $fiat_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option<?php echo e((data_get($settings, 'config.meta.fiat')==$code) ? ' selected ' : ''); ?> value="<?php echo e($code); ?>"><?php echo e($name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="form-note"><?php echo e(__('Crypto amount show in currency')); ?></div>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-xl-6 col-xxl-3">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Max Time for Payment')); ?><span class="text-danger"></span></label>
                                            <div class="form-control-wrap">
                                                <select name="config[meta][timeout]" class="form-select">
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='0') ? ' selected ' : ''); ?> value="0"><?php echo e(__('No Limit')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='30') ? ' selected ' : ''); ?> value="30"><?php echo e(__('Max 30 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='60') ? ' selected ' : ''); ?> value="60"><?php echo e(__('Max 60 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='90') ? ' selected ' : ''); ?> value="90"><?php echo e(__('Max 90 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='120') ? ' selected ' : ''); ?> value="120"><?php echo e(__('Max 120 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='150') ? ' selected ' : ''); ?> value="150"><?php echo e(__('Max 150 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='180') ? ' selected ' : ''); ?> value="180"><?php echo e(__('Max 180 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='210') ? ' selected ' : ''); ?> value="210"><?php echo e(__('Max 210 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='240') ? ' selected ' : ''); ?> value="240"><?php echo e(__('Max 240 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='300') ? ' selected ' : ''); ?> value="300"><?php echo e(__('Max 300 Minutes')); ?></option>
                                                    <option<?php echo e((data_get($settings, 'config.meta.timeout')=='360') ? ' selected ' : ''); ?> value="360"><?php echo e(__('Max 360 Minutes')); ?></option>
                                                </select>
                                            </div>
                                            <div class="form-note"><?php echo e(__('An expiry countdown will display.')); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <div class="form-group">
                                            <label class="form-label"><?php echo e(__('Method Name')); ?> <span class="small"><?php echo e(__('Alternet')); ?></span></label>
                                            <div class="form-control-wrap">
                                                <input type="text" name="config[meta][title]" class="form-control" value="<?php echo e(data_get($settings, 'config.meta.title')); ?>">
                                            </div>
                                            <div class="form-note"><?php echo e(__('Method title will use if leave blank.')); ?></div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <label class="form-label" for="currency-supported"><?php echo e(__('Supported Wallet')); ?></label>
                                        <div class="form-control-group">
                                            <ul class="custom-control-group g-2 align-center flex-wrap li-w225">
                                                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <div class="custom-control custom-control-sm custom-switch">
                                                        <input type="checkbox" class="custom-control-input toggle-switch-opt" name="currencies[]" data-switch="switch-to-wallet-<?php echo e(strtolower(data_get($currency, 'code'))); ?>" value="<?php echo e(data_get($currency, 'code')); ?>" id="cur-<?php echo e(data_get($currency, 'code')); ?>"<?php echo e(!is_active_currency(data_get($currency, 'code')) ? ' disabled' : ''); ?> <?php if(in_array(data_get($currency, 'code'), data_get($settings, 'currencies', []))): ?> checked <?php endif; ?>>
                                                        <label class="custom-control-label" for="cur-<?php echo e(data_get($currency, 'code')); ?>"><?php echo e(__(':name (:code)', ["name" => data_get($currency, 'name'), "code" => data_get($currency, 'code')])); ?></label>
                                                    </div>
                                                </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                        <div class="note mt-4 pl-2 border-left border-primary">
                                            <p>
                                                <strong><?php echo e(__('Please Note:')); ?></strong><br>
                                                <em class="icon ni ni-dot"></em> <?php echo e(__('Ensure you have access of your wallet and entered correct address.')); ?><br>
                                                <em class="icon ni ni-dot"></em> <?php echo e(__('The address will display to user when they going to deposit / payment.')); ?><br>
                                                <em class="icon ni ni-dot"></em> <?php echo e(__('A payment reference (optional) form will display to user if field set show.')); ?><br>
                                                <em class="icon ni ni-dot"></em> <?php echo e(__('If enable supported wallet but did not add address then it will inactive automatically.')); ?></p>
                                        </div> 
                                        <div class="note mt-2 pl-2 border-left border-primary">
                                            <p><small><sup>1</sup></small> 
                                                <?php echo e(__("The amount will apply only if its more than the base minimum deposit amount.")); ?><br>
                                                <small><sup>2</sup></small> 
                                                <?php echo e(__("The fixed minimum amount will be set and override to any minimum deposit amount.")); ?><br>
                                            </p>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                            <div class="form-set wide-md">
                                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $code = $currency['code']; $code_lower = strtolower($currency['code']); ?>
                                <div class="switch-content switch-to-wallet-<?php echo e($code_lower); ?><?php echo e((in_array(data_get($currency, 'code'), data_get($settings, 'currencies', []))) ? ' switch-active' : ''); ?>">
                                    <div class="card bg-lighter p-3 pb-4 mt-4">
                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="wallet-<?php echo e($code_lower); ?>"><?php echo e(__(':name Payment Address', ['name' => data_get($currency, 'name')])); ?></label>
                                                    <div class="form-control-wrap">
                                                        <div class="form-icon form-icon-left"><em class="icon ni <?php echo e(data_get($currency, 'symbol')); ?>"></em></div>
                                                        <input id="wallet-<?php echo e($code_lower); ?>" type="text" placeholder="<?php echo e(__('Enter your :currency wallet address', ['currency' => data_get($currency, 'code') ])); ?>" class="form-control" name="config[wallet][<?php echo e($code); ?>][address]" value="<?php echo e(data_get($settings, 'config.wallet.'.$code.'.address')); ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="row g-3">
                                                    <div class="col-6">
                                                        <div class="form-group">
                                                            <label class="form-label"><?php echo e(__('Minimum')); ?> <small><sup>2</sup></small> </label>
                                                            <div class="form-control-wrap">
                                                                <div class="form-text-hint"><span><?php echo e($code); ?></span></div>
                                                                <input type="number" class="form-control" name="config[wallet][<?php echo e($code); ?>][min]" value="<?php echo e(data_get($settings, 'config.wallet.'.$code.'.min', '0')); ?>" min="0">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-6">
                                                        <div class="form-group">
                                                            <label class="form-label" for="wallet-<?php echo e($code_lower); ?>-ref"><?php echo e(__('Reference Field')); ?></label>
                                                            <div class="form-control-wrap">
                                                                <select name="config[wallet][<?php echo e($code); ?>][ref]" class="form-select" id="wallet-<?php echo e($code_lower); ?>-ref">
                                                                    <option<?php echo e((data_get($settings, 'config.wallet.'.$code.'.ref')=='no') ? ' selected ' : ''); ?> value="no"><?php echo e(__('Hide')); ?></option>
                                                                    <option<?php echo e((data_get($settings, 'config.wallet.'.$code.'.ref')=='yes') ? ' selected ' : ''); ?> value="yes"><?php echo e(__('Show')); ?></option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php if($code=='ETH'): ?>
                                            <div class="col-12">
                                                <div class="row g-3">
                                                    <div class="col-6 col-md-3">
                                                        <div class="form-group">
                                                            <label class="form-label"><?php echo e(__('Gas Limit')); ?></label>
                                                            <div class="form-control-wrap">
                                                                <input class="form-control" placeholder="Optional" type="text" name="config[wallet][<?php echo e($code); ?>][limit]" value="<?php echo e(data_get($settings, 'config.wallet.'.$code.'.limit')); ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-6 col-md-3">
                                                        <div class="form-group">
                                                            <label class="form-label"><?php echo e(__('Gas Price')); ?></label>
                                                            <div class="form-control-wrap">
                                                                <input class="form-control" placeholder="Optional" type="text" name="config[wallet][<?php echo e($code); ?>][price]" value="<?php echo e(data_get($settings, 'config.wallet.'.$code.'.price')); ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="divider"></div>
                            <div class="d-flex justify-between">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="slug" value="<?php echo e(data_get($config, 'slug')); ?>">
                                <div class="custom-control custom-switch">
                                    <input class="switch-option-value" type="hidden" name="status" value="<?php echo e(data_get($settings, 'status') ?? 'inactive'); ?>">
                                    <input type="checkbox" class="custom-control-input switch-option" data-switch="active"<?php echo e((data_get($settings, 'status', 'inactive') == 'active') ? ' checked' : ''); ?>  id="enable-method">
                                    <label class="custom-control-label" for="enable-method"><span class="over"></span><span><?php echo e(__('Enable Method')); ?></span></label>
                                </div>
                                <button type="button" class="btn btn-primary submit-settings" disabled="">
                                    <span class="spinner-border spinner-border-sm hide" role="status" aria-hidden="true"></span>
                                    <span><?php echo e(__('Update')); ?></span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.modules', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\niomodules\CryptoWallet\Views/settings.blade.php ENDPATH**/ ?>