<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(site_info('name')); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/apps-admin.css?ver=1.0.0')); ?>">
<?php if(sys_settings('ui_theme_skin_admin', 'default') != 'default'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/skins/theme-'.sys_settings('ui_theme_skin_admin').'.css?ver=1.0.0')); ?>">
<?php endif; ?>
</head>

<body class="nk-body npc-cryptlite npc-admin has-sidebar">
<div class="nk-app-root">

    <div class="nk-main ">

        <?php echo $__env->make('admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="nk-wrap <?php echo $__env->yieldContent('has-content-sidebar'); ?>">

            <?php echo $__env->make('admin.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->yieldContent('content-sidebar'); ?>

            <div class="nk-content ">
                <div class="container-fluid ">

                    <?php echo $__env->make('misc.message-admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('misc.notices', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo $__env->yieldContent('content'); ?>

                </div>
            </div>

            <?php echo $__env->make('admin.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
    </div>
</div>

<?php echo $__env->yieldPushContent('modal'); ?>

<script src="<?php echo e(asset('assets/js/bundle.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/app.admin.js')); ?>"></script>
<?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>
<?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/layouts/master.blade.php ENDPATH**/ ?>