
<?php $__env->startSection('title', __('Application Quick Setup')); ?>

<?php 

$service = (isset($type) && $type=='system') ? 'system' : false;
$notice = ((gss('system' .'_'. 'service') && !gas()) || (session()->has('notice') && session()->pull('notice') == $service)) ? true : false;
$notice = (session()->has('system'. '_' .'revoke')) ? false : $notice;    

?>

<?php $__env->startSection('content'); ?>
<div class="nk-content-body">
    <div class="content-page wide-lg m-auto">
    <?php if($service == 'system'): ?>
        <div class="nk-block-head nk-block-head-lg text-center mt-md-3">
            <h4 class="title text-center pb-1"><?php echo e('System License Activation'); ?></h4>
            <p class="w-max-550px m-auto"><?php echo e('To unlock the application is required valid purchase information. Please provide your purchase information to activate the application and continue.'); ?></p>
        </div>
        <div class="nk-block wide-md m-auto">
            <div class="card card-bordered">
                <div class="card-inner card-inner-lg">
                    <div class="row gy-4 gx-5">
                        <div class="col-md-6 col-lg-7">
                            <?php echo $__env->make('Utility::system.register', ['notice' => $notice], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-md-6 col-lg-5">
                            <?php echo $__env->make('Utility::system.info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="nk-block-head nk-block-head-lg text-center mt-md-3">
            <h4 class="title text-center pb-2"><?php echo e(__('Quick Application Setup')); ?></h4>
            <p class="w-max-550px m-auto"><?php echo e(__('This setup wizard helps you to complete your application setting quickly which is required to run the application. You can update all the setting anytime later.')); ?></p>
        </div>

        <div class="nk-block wide-xs m-auto">
            <div class="card card-bordered">
                <div class="card-inner card-inner-lg">
                    <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible">
                        <div class="alert-text">
                            <div class="alert-text">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <p><?php echo e($error); ?></p>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <button class="close" data-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>

                    <div class="quick-setup">
                        <?php if($state!=='complete'): ?>
                        <?php echo $__env->make('admin.settings.quick.form-'.$state, ['step' => $state], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="quick-skip text-center mt-4">
                <a class="link link-light" href="<?php echo e(route('admin.quick-setup', ['skip' => 'quick'])); ?>"><?php echo e(__("Dont ask me again")); ?></a>
            </div>
        </div>
    <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.minimal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/settings/application-setup.blade.php ENDPATH**/ ?>