
<?php $__env->startSection('title', __('General Settings')); ?>

<?php $__env->startSection('has-content-sidebar', 'has-content-sidebar'); ?>

<?php $__env->startSection('content-sidebar'); ?>
    <?php echo $__env->make('admin.settings.content-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php

use App\Enums\LangStatus;

?>

<?php $__env->startSection('content'); ?>
    <div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"><?php echo e(__('General Settings')); ?></h3>
                    <p><?php echo e(__('Global settings of the application that you can manage easily.')); ?></p>
                </div>
                <div class="nk-block-head-content">
                    <ul class="nk-block-tools gx-1">
                        <li class="d-lg-none">
                            <a href="#" class="btn btn-icon btn-trigger toggle" data-target="pageSidebar"><em
                                    class="icon ni ni-menu-right"></em></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="nk-block card card-bordered">
            <div class="card-inner">
                <form action="<?php echo e(route('admin.save.app.settings')); ?>" class="form-settings" method="POST">
                    <h5 class="title"><?php echo e(__('Timezone and Format')); ?></h5>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Time Zone')); ?></label>
                                    <span class="form-note"><?php echo e(__('Set timezone on application.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap w-max-250px">
                                        <select name="time_zone" class="form-select">
                                            <?php $__currentLoopData = config('investorm.timezones'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"
                                                    <?php echo e(sys_settings('time_zone') == $key ? ' selected' : ''); ?>>
                                                    <?php echo e(__($item)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Date Format')); ?></label>
                                    <span class="form-note"><?php echo e(__('Set date format to display date.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap w-max-250px">
                                        <select name="date_format" class="form-select">
                                            <?php $__currentLoopData = config('investorm.date_formats'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"
                                                    <?php echo e(sys_settings('date_format') == $key ? ' selected' : ''); ?>>
                                                    <?php echo e(__($item)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Time Format')); ?></label>
                                    <span class="form-note"><?php echo e(__('Set time format to display time.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap w-max-250px">
                                        <select name="time_format" class="form-select">
                                            <?php $__currentLoopData = config('investorm.time_formats'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($key); ?>"
                                                    <?php echo e(sys_settings('time_format') == $key ? ' selected' : ''); ?>>
                                                    <?php echo e(__($item)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="divider"></div>
                    <h5 class="title"><?php echo e(__('Decimal Option')); ?></h5>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-start">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Maximum Decimal')); ?> <span class="small"> -
                                            <?php echo e(__('Application')); ?></span></label>
                                    <span
                                        class="form-note"><?php echo e(__('Number of decimal maintain in system calculation.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="form-control-wrap">
                                                <input type="number" class="form-control" min="2" max="6"
                                                    name="decimal_fiat_calc"
                                                    value="<?php echo e(sys_settings('decimal_fiat_calc', '2')); ?>">
                                            </div>
                                            <div class="form-note">
                                                <strong><?php echo e(__('Fiat Currency')); ?></strong>
                                                <?php echo e(__('(2 to 6 accepted; default: 2)')); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="form-control-wrap">
                                                <input type="number" class="form-control" min="4" max="12"
                                                    name="decimal_crypto_calc"
                                                    value="<?php echo e(sys_settings('decimal_crypto_calc', '6')); ?>">
                                            </div>
                                            <div class="form-note">
                                                <strong><?php echo e(__('Crypto Currency')); ?></strong>
                                                <?php echo e(__('(4 to 12 accepted; default: 6)')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 align-start">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Decimal Display')); ?> <span class="small"> -
                                            <?php echo e(__('Optional / Alternate')); ?></span></label>
                                    <span class="form-note"><?php echo e(__('Usually use to display account balance.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="form-control-wrap">
                                                <input type="number" class="form-control" min="1" max="4"
                                                    name="decimal_fiat_display"
                                                    value="<?php echo e(sys_settings('decimal_fiat_display', '2')); ?>">
                                            </div>
                                            <div class="form-note">
                                                <strong><?php echo e(__('Fiat Currency')); ?></strong>
                                                <?php echo e(__('(1 to 4 accepted; default: 2)')); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="form-control-wrap">
                                                <input type="number" class="form-control" min="4" max="8"
                                                    name="decimal_crypto_display"
                                                    value="<?php echo e(sys_settings('decimal_crypto_display', '4')); ?>">
                                            </div>
                                            <div class="form-note">
                                                <strong><?php echo e(__('Crypto Currency')); ?></strong>
                                                <?php echo e(__('(4 to 8 accepted; default: 4)')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3">
                            <div class="col-md-7 offset-lg-5">
                                <div class="form-group mt-2">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="form_type" value="general-settings">
                                    <button type="button" class="btn btn-primary submit-settings" disabled="">
                                        <span class="spinner-border spinner-border-sm hide" role="status"
                                            aria-hidden="true"></span>
                                        <span><?php echo e(__('Update')); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="nk-block card card-bordered" id="language-settings">
            <div class="card-inner">
                <h5 class="title"><?php echo e(__('Language Setting')); ?></h5>
                <form action="<?php echo e(route('admin.save.app.settings')); ?>" class="form-settings" method="POST" autocomplete="off">
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label" for="lang-supported"><?php echo e(__('Default Language')); ?></label>
                                    <span class="form-note"><?php echo e(__('Set default language on application.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="row gy-2">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="form-control-wrap">
                                                <select class="form-select" id="default-lang-adminend" name="default_system">
                                                    <option value="0"<?php echo e((gss('language_default_system') == 0) ? ' selected' : ''); ?>><?php echo e(__('System')); ?></option>
                                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($lang->code); ?>"<?php echo e((gss('language_default_system') === $lang->code) ? ' selected' : ''); ?><?php echo e(($lang->status == 0) ? ' disabled' : ''); ?>>
                                                            <?php echo e($lang->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="form-note mt-1 fw-bold text-secondary"><?php echo e(__("Admin Panel")); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="form-control-wrap">
                                                <select class="form-select" id="default-lang-userpanel" name="default_public">
                                                    <option value="0"<?php echo e((gss('language_default_public') == 0) ? ' selected' : ''); ?>><?php echo e(__('System')); ?></option>
                                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($lang->code); ?>"<?php echo e((gss('language_default_public') === $lang->code) ? ' selected' : ''); ?><?php echo e(($lang->status == 0) ? ' disabled' : ''); ?>>
                                                            <?php echo e($lang->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="form-note mt-1 fw-bold text-secondary"><?php echo e(__("User Panel")); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Language Switcher')); ?></label>
                                    <span class="form-note"><?php echo e(__('Display a switcher to quick switch language.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="row gy-2">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="form-control-wrap">
                                                <select class="form-select" id="language-switcher-label" name="show_as">
                                                    <option value="default"<?php echo e((gss('language_show_as') == 'default') ? ' selected' : ''); ?>><?php echo e(__("Use System Default")); ?></option>
                                                    <option value="label"<?php echo e((gss('language_show_as') == 'label') ? ' selected' : ''); ?>><?php echo e(__("Use Own Label")); ?></option>
                                                    <option value="short"<?php echo e((gss('language_show_as') == 'short') ? ' selected' : ''); ?>><?php echo e(__("Use Short Name")); ?></option>
                                                    <option value="code"<?php echo e((gss('language_show_as') == 'code') ? ' selected' : ''); ?>><?php echo e(__("Use Code Name")); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <div class="custom-control custom-switch custom-control-labeled">
                                                <input class="switch-option-value" type="hidden" name="switcher" value="<?php echo e(sys_settings('language_switcher') ?? 'off'); ?>">
                                                <input id="lang-switch" type="checkbox" class="custom-control-input switch-option" data-switch="on" <?php echo e(sys_settings('language_switcher', 'off') == 'on' ? ' checked=""' : ''); ?>>
                                                <label for="lang-switch" class="custom-control-label"><?php echo e(__('Enable')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3">
                            <div class="col-md-7 offset-lg-5">
                                <div class="form-group mt-2">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="form_prefix" value="language">
                                    <input type="hidden" name="form_type" value="language-settings">
                                    <button type="button" class="btn btn-primary submit-settings" disabled="">
                                        <span class="spinner-border spinner-border-sm hide" role="status"
                                            aria-hidden="true"></span>
                                        <span><?php echo e(__('Update')); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="nk-block card card-bordered">
            <div class="card-inner">
                <form action="<?php echo e(route('admin.save.app.settings')); ?>" class="form-settings" method="POST">
                    <h5 class="title"><?php echo e(__('Registration Option')); ?></h5>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Allow Registration')); ?></label>
                                    <span class="form-note"><?php echo e(__('Enable or disable registration from site.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <ul class="custom-control-group g-3 align-center flex-wrap">
                                    <li>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" class="custom-control-input" id="reg-enable" value="enable"
                                                name="signup_allow"
                                                <?php echo e(sys_settings('signup_allow', 'enable') == 'enable' ? ' checked=""' : ''); ?>>
                                            <label class="custom-control-label"
                                                for="reg-enable"><?php echo e(__('Enable')); ?></label>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="custom-control custom-radio">
                                            <input type="radio" class="custom-control-input" name="signup_allow"
                                                value="disable" id="reg-disable"
                                                <?php echo e(sys_settings('signup_allow', 'enable') == 'disable' ? ' checked=""' : ''); ?>>
                                            <label class="custom-control-label"
                                                for="reg-disable"><?php echo e(__('Disable')); ?></label>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Verification Required')); ?></label>
                                    <span
                                        class="form-note"><?php echo e(__('Required email verification after registration.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input class="switch-option-value" type="hidden" name="email_verification"
                                            value="<?php echo e(sys_settings('email_verification') ?? 'on'); ?>">
                                        <input id="email-verify-option" type="checkbox"
                                            class="custom-control-input switch-option" data-switch="on"
                                            <?php echo e(sys_settings('email_verification', 'on') == 'on' ? ' checked=""' : ''); ?>>
                                        <label for="email-verify-option"
                                            class="custom-control-label"><?php echo e(__('Enable')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"
                                        for="enable-referral-system"><?php echo e(__('Referral System')); ?></label>
                                    <span
                                        class="form-note w-max-350px"><?php echo e(__('Users able to invite people using their referral id.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input class="switch-option-value" type="hidden" name="referral_system"
                                            value="<?php echo e(sys_settings('referral_system') ?? 'no'); ?>">
                                        <input id="enable-referral-system" type="checkbox"
                                            class="custom-control-input switch-option" data-switch="yes"
                                            <?php echo e(sys_settings('referral_system', 'no') == 'yes' ? ' checked=""' : ''); ?>>
                                        <label for="enable-referral-system"
                                            class="custom-control-label"><?php echo e(__('Enable')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="divider"></div>
                    <h5 class="title"><?php echo e(__('Maintanance')); ?></h5>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Maintanance Mode')); ?></label>
                                    <span class="form-note"><?php echo e(__('Enable to make website make offline.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input class="switch-option-value" type="hidden" name="maintenance_mode"
                                            value="<?php echo e(sys_settings('maintenance_mode') ?? 'off'); ?>">
                                        <input id="maintenance-option" type="checkbox"
                                            class="custom-control-input switch-option" data-switch="on"
                                            <?php echo e(sys_settings('maintenance_mode', 'off') == 'on' ? ' checked=""' : ''); ?>>
                                        <label for="maintenance-option"
                                            class="custom-control-label"><?php echo e(__('Offline')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row g-3 align-start">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Maintenance Notice')); ?></label>
                                    <span class="form-note"><?php echo e(__('Specify the email address of your website.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <textarea class="form-control"
                                            name="maintenance_notice"><?php echo e(sys_settings('maintenance_notice')); ?></textarea>
                                    </div>
                                    <div class="form-note">
                                        <span><?php echo e(__('Admin Login on maintenance mode:')); ?> <strong
                                                class="text-primary"><?php echo e(url('/admin/login')); ?></strong></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3">
                            <div class="col-md-7 offset-lg-5">
                                <div class="form-group mt-2">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="form_type" value="application-settings">
                                    <button type="button" class="btn btn-primary submit-settings" disabled="">
                                        <span class="spinner-border spinner-border-sm hide" role="status"
                                            aria-hidden="true"></span>
                                        <span><?php echo e(__('Update')); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/settings/general.blade.php ENDPATH**/ ?>