<div class="nk-sidebar nk-sidebar-fixed<?php echo e((gui('admin', 'sidebar')=='darker') ? ' is-dark' : ' is-light'); ?>" data-content="sidebarMenu">
    <div class="nk-sidebar-element nk-sidebar-head">

        <?php echo e(site_branding('sidebar', ['panel' => 'back', 'class_link' => 'nk-sidebar-logo', 'size' => 24])); ?>


        <div class="nk-menu-trigger mr-n2">
            <a href="javascript:void(0)" class="nk-nav-toggle nk-quick-nav-icon d-xl-none" data-target="sidebarMenu"><em class="icon ni ni-arrow-left"></em></a>
        </div>
    </div>
    <div class="nk-sidebar-element">
        <div class="nk-sidebar-content">
            <div class="nk-sidebar-menu" data-simplebar>
                <ul class="nk-menu">
                    <li class="nk-menu-item<?php echo e(is_route('admin.dashboard') ? ' active' : ''); ?>">
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="nk-menu-link">
                            <span class="nk-menu-icon"><em class="icon ni ni-dashboard"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Dashboard')); ?></span>
                        </a>
                    </li>
                    <li class="nk-menu-item<?php echo e(is_route('admin.transactions.deposit.all') ? ' active' : ''); ?>">
                        <a href="<?php echo e(route('admin.transactions.deposit.all', ['status' => ($pendingDepositCount > 0) ? 'pending' : 'any'])); ?>" class="nk-menu-link">
                            <span class="nk-menu-icon"><em class="icon ni ni-wallet-in"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Deposit')); ?></span>
                            <?php if($pendingDepositCount > 0): ?>
                                <span class="nk-menu-badge"><?php echo e($pendingDepositCount); ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <li class="nk-menu-item<?php echo e(is_route('admin.transactions.withdraw.all') ? ' active' : ''); ?>">
                        <a href="<?php echo e(route('admin.transactions.withdraw.all', ['status' => ($pendingWithdrawCount > 0) ? 'pending' : 'any'])); ?>" class="nk-menu-link">
                            <span class="nk-menu-icon"><em class="icon ni ni-wallet-out"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Withdraw')); ?></span>
                            <?php if($pendingWithdrawCount > 0): ?>
                                <span class="nk-menu-badge"><?php echo e($pendingWithdrawCount); ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <li class="nk-menu-item<?php echo e(is_route('admin.transactions.referral.all') ? ' active' : ''); ?>">
                        <a href="<?php echo e(route('admin.transactions.referral.all', ['status' => ($pendingReferralCount > 0) ? 'pending' : 'any'])); ?>" class="nk-menu-link">
                            <span class="nk-menu-icon"><em class="icon ni ni-percent"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Referral')); ?></span>
                            <?php if($pendingReferralCount > 0): ?>
                                <span class="nk-menu-badge"><?php echo e($pendingReferralCount); ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <li class="nk-menu-item has-sub<?php echo e(is_route('admin.transactions.list*') ? ' active' : ''); ?>">
                        <a href="javascript:void(0)" class="nk-menu-link nk-menu-toggle">
                            <span class="nk-menu-icon"><em class="icon ni ni-tranx"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Transaction')); ?></span>
                        </a>
                        <ul class="nk-menu-sub">
                            <?php if($pendingTransactionCount > 0): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.transactions.list') && (request('list_type') == 'pending') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.transactions.list', ['list_type' => 'pending'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Pending')); ?> <span class="small">(<?php echo e($pendingTransactionCount); ?>)</span></span></a>
                            </li>
                            <?php endif; ?>
                            <?php if($onholdTransactionCount > 0): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.transactions.list') && (request('list_type') == 'on-hold') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.transactions.list', ['list_type' => 'on-hold'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('On Hold')); ?> <span class="small">(<?php echo e($onholdTransactionCount); ?>)</span></span></a>
                            </li>
                            <?php endif; ?>
                            <?php if($confirmedTransactionCount > 0): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.transactions.list') && (request('list_type') == 'confirmed') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.transactions.list', ['list_type' => 'confirmed'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Confirmed')); ?> <span class="small">(<?php echo e($confirmedTransactionCount); ?>)</span></span></a>
                            </li>
                            <?php endif; ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.transactions.list') && (request('list_type') == 'deposit') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.transactions.list', ['list_type' => 'deposit'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Deposit')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e(is_route('admin.transactions.list') && (request('list_type') == 'withdraw') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.transactions.list', ['list_type' => 'withdraw'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Withdrawal')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e(is_route('admin.transactions.list') && is_null(request('list_type')) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.transactions.list')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('All Transaction')); ?></span></a>
                            </li>
                        </ul>
                    </li>
                    <li class="nk-menu-heading">
                        <h6 class="overline-title text-primary-alt"><?php echo e(__('Investment')); ?></h6>
                    </li>
                    <?php if(has_route('admin.investment.dashboard')): ?>
                        <li class="nk-menu-item<?php echo e(is_route('admin.investment.dashboard') ? ' active' : ''); ?>">
                            <a href="<?php echo e(route('admin.investment.dashboard')); ?>" class="nk-menu-link">
                                <span class="nk-menu-icon"><em class="icon ni ni-growth"></em></span>
                                <span class="nk-menu-text"><?php echo e(__('Invest Dashboard')); ?></span>
                            </a>
                        <?php endif; ?>
                    </li>
                    <li class="nk-menu-item has-sub<?php echo e((is_route('admin.investment.list*') || is_route('admin.investment.schemes') || is_route('admin.investment.details*')) ? ' active' : ''); ?>">
                        <a href="javascript:void(0)" class="nk-menu-link nk-menu-toggle">
                            <span class="nk-menu-icon"><em class="icon ni ni-invest"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Invested Plans')); ?></span>
                        </a>
                        <ul class="nk-menu-sub">
                            <?php if(has_route('admin.investment.list')): ?>
                            <li class="nk-menu-item<?php echo e((is_route('admin.investment.list') && request()->route('status') == 'active') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.list', ['status' => 'active'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Actived Invest')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e((is_route('admin.investment.list') && request()->route('status') == 'pending') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.list', ['status' => 'pending'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Pending Invest')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e((is_route('admin.investment.list') && request()->route('status') == 'completed') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.list', ['status' => 'completed'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Completed Invest')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e((is_route('admin.investment.list') && empty(request()->route('status'))) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.list')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('All Invested Plans')); ?></span></a>
                            </li>
                            <?php endif; ?>
                            <?php if(has_route('admin.investment.schemes')): ?>
                                <li class="nk-menu-item<?php echo e((is_route('admin.investment.schemes')) ? ' active' : ''); ?>">
                                    <a href="<?php echo e(route('admin.investment.schemes')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Manage Schemes')); ?></span></a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <li class="nk-menu-item has-sub<?php echo e((is_route('admin.investment.transactions*') || is_route('admin.investment.profits*')) ? ' active' : ''); ?>">
                        <a href="javascript:void(0)" class="nk-menu-link nk-menu-toggle">
                            <span class="nk-menu-icon"><em class="icon ni ni-calc"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Invest Statement')); ?></span>
                        </a>
                        <ul class="nk-menu-sub">
                            <?php if(has_route('admin.investment.transactions.list')): ?>
                            <li class="nk-menu-item<?php echo e((is_route('admin.investment.transactions.list') && empty(request()->route('type'))) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.transactions.list')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('All Transactions')); ?></span></a>
                            </li>
                            <?php endif; ?>
                            <?php if(has_route('admin.investment.transactions.list')): ?>
                            <li class="nk-menu-item<?php echo e((is_route('admin.investment.transactions.list') && request()->route('type') == 'profit') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.transactions.list', 'profit')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Profit Settlement')); ?></span></a>
                            </li>
                            <?php endif; ?>
                            <?php if(has_route('admin.investment.transactions.list')): ?>
                            <li class="nk-menu-item<?php echo e((is_route('admin.investment.transactions.list') && request()->route('type') == 'transfer') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.transactions.list', 'transfer')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Transferred History')); ?></span></a>
                            </li>
                            <?php endif; ?>
                            <?php if(has_route('admin.investment.profits.list')): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.investment.profits.list') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.investment.profits.list')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Profit / Interest Logs')); ?></span></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <li class="nk-menu-heading">
                        <h6 class="overline-title text-primary-alt"><?php echo e(__('User Management')); ?></h6>
                    </li>
                    <li class="nk-menu-item has-sub<?php echo e(is_route('admin.users*') ? ' active' : ''); ?>">
                        <a href="javascript:void(0)" class="nk-menu-link nk-menu-toggle">
                            <span class="nk-menu-icon"><em class="icon ni ni-users"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Manage Users')); ?></span>
                        </a>
                        <ul class="nk-menu-sub">
                            <li class="nk-menu-item<?php echo e(is_route('admin.users') && (request('state') == 'active') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.users', ['state' => 'active'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Active')); ?></span></a>
                            </li>
                            
                            <?php if(isset($userCount['inactive']) && ($userCount['inactive'] > 0)): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.users') && (request('state') == 'inactive') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.users', ['state' => 'inactive'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Inactive')); ?> <span class="small">(<?php echo e($userCount['inactive'] ?? 0); ?>)</span></span></a>
                            </li>
                            <?php endif; ?>

                            <?php if(isset($userCount['locked']) && ($userCount['locked'] > 0)): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.users') && (request('state') == 'locked') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.users', ['state' => 'locked'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Locked')); ?> <span class="small">(<?php echo e($userCount['locked'] ?? 0); ?>)</span></span></a>
                            </li>
                            <?php endif; ?>

                            <?php if(isset($userCount['suspend']) && ($userCount['suspend'] > 0)): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.users') && (request('state') == 'suspend') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.users', ['state' => 'suspend'])); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Suspended')); ?> <span class="small">(<?php echo e($userCount['suspend'] ?? 0); ?>)</span></span></a>
                            </li>
                            <?php endif; ?>

                            <li class="nk-menu-item<?php echo e((is_route('admin.users') && (request('state') == '')) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.users')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('All Users')); ?></span></a>
                            </li>

                            <?php if(isset($adminUserCount) && ($adminUserCount > 0)): ?>
                            <li class="nk-menu-item<?php echo e((is_route('admin.users.administrator')) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.users.administrator')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Administrator')); ?> <span class="small">(<?php echo e($adminUserCount ?? 0); ?>)</span></span></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <li class="nk-menu-heading">
                        <h6 class="overline-title text-primary-alt"><?php echo e(__('Management')); ?></h6>
                    </li>
                    <li class="nk-menu-item has-sub<?php echo e((is_route('admin.manage.*')) ? ' active' : ''); ?>">
                        <a href="javascript:void(0)" class="nk-menu-link nk-menu-toggle">
                            <span class="nk-menu-icon"><em class="icon ni ni-files"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Manage Content')); ?></span>
                        </a>
                        <ul class="nk-menu-sub">
                            <li class="nk-menu-item<?php echo e((is_route('admin.manage.pages*')) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.manage.pages')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Manage Pages')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e((is_route('admin.manage.email*')) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.manage.email.template')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Email Templates')); ?></span></a>
                            </li>
                        </ul>
                    </li>
                    <li class="nk-menu-item<?php echo e((is_route('admin.system.langs')) ? ' active' : ''); ?>">
                        <a href="<?php echo e(route('admin.system.langs')); ?>" class="nk-menu-link">
                            <span class="nk-menu-icon"><em class="icon ni ni-text-a"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Manage Language')); ?></span>
                        </a>
                    </li>
                    <li class="nk-menu-item has-sub<?php echo e((is_route('admin.settings.*') || is_route('admin.systeminfo')) ? ' active' : ''); ?>">
                        <a href="javascript:void(0)" class="nk-menu-link nk-menu-toggle">
                            <span class="nk-menu-icon"><em class="icon ni ni-setting"></em></span>
                            <span class="nk-menu-text"><?php echo e(__('Application Settings')); ?></span>
                        </a>
                        <ul class="nk-menu-sub">
                            <li class="nk-menu-item<?php echo e(is_route('admin.settings.global.*') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.settings.global.general')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Global Settings')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e((is_route('admin.settings.website*')) ? ' active' : ''); ?><?php echo e((is_route('admin.settings.website.*')) ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.settings.website')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Website Settings')); ?></span></a>
                            </li>
                            <li class="nk-menu-item<?php echo e(is_route('admin.settings.gateway.*') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.settings.gateway.option')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Payment Options')); ?></span></a>
                            </li>
                            <?php if(has_route('admin.settings.investment.apps')): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.settings.investment.apps') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.settings.investment.apps')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Investment Apps')); ?></span></a>
                            </li>
                            <?php endif; ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.settings.email') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.settings.email')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('Email Cofiguration')); ?></span></a>
                            </li>
                            <?php if(has_sysinfo()): ?>
                            <li class="nk-menu-item<?php echo e(is_route('admin.systeminfo') ? ' active' : ''); ?>">
                                <a href="<?php echo e(route('admin.systeminfo')); ?>" class="nk-menu-link"><span class="nk-menu-text"><?php echo e(__('System Status')); ?></span></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>