<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">
<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $__env->yieldContent('title', 'Welcome'); ?> | <?php echo e(site_info('name')); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/apps.css?ver=1.1.0')); ?>">
<?php if(!empty(global_meta_content('seo'))): ?>
    <?php echo global_meta_content('seo'); ?>

<?php endif; ?>
<?php if(!empty(global_meta_content('share'))): ?>
    <?php echo global_meta_content('share'); ?>

<?php endif; ?>
<?php if(sys_settings('google_track_id')): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(sys_settings('google_track_id')); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || []; function gtag(){dataLayer.push(arguments);} gtag('js', new Date()); gtag('config', "<?php echo e(sys_settings('google_track_id')); ?>");
    </script>
<?php endif; ?>
<?php if(has_recaptcha()): ?>
    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(recaptcha_key('site')); ?>"></script>
<?php endif; ?>
<?php if(sys_settings('header_code')): ?>
    <?php echo e(html_string(sys_settings('header_code'))); ?>

<?php endif; ?>
</head>
<body class="nk-body npc-cryptlite pg-auth<?php echo e((gui('skin', 'auth')=='dark') ? ' is-dark' : ''); ?>">
<div class="nk-app-root">
    <div class="nk-wrap">
        <div class="nk-block nk-block-middle nk-auth-body wide-xs">

            <?php echo e(site_branding('header', ['panel' => 'auth', 'size' => 'lg', 'class' => 'pb-4'])); ?>


            <?php echo $__env->yieldContent('content'); ?>

            <?php echo Panel::socials('any', ['class' => 'icon-list justify-center pt-4',  'parent' => true ]); ?>


        </div>

        <?php echo $__env->make('auth.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</div>
<script src="<?php echo e(asset('/assets/js/bundle.js')); ?>"></script>
<script src="<?php echo e(asset('/assets/js/app.js')); ?>"></script>
<?php echo $__env->yieldPushContent('scripts'); ?>
<?php if(sys_settings('tawk_api_key')): ?>
<script type="text/javascript">
    var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();(function(){var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];s1.async=true;s1.src="https://embed.tawk.to/<?php echo e(sys_settings('tawk_api_key')); ?>/default";s1.charset="UTF-8";s1.setAttribute("crossorigin","*");s0.parentNode.insertBefore(s1,s0);})();
</script>
<?php endif; ?>
<?php if(sys_settings('footer_code')): ?>
    <?php echo e(html_string(sys_settings('footer_code'))); ?>

<?php endif; ?>
</body>
</html><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/auth/layouts/master.blade.php ENDPATH**/ ?>